"use strict";
let pxtCore = null;
let pendingEvents = [];
function init(pxt) {
    pxtCore = pxt;
    pendingEvents.forEach((e) => tickEvent(e.event, e.data));
    pendingEvents = [];
}
exports.init = init;
function tickEvent(event, data) {
    const eventInfo = {
        event,
        data
    };
    if (pxtCore) {
        pxtCore.sendElectronMessage({
            type: "telemetry",
            args: eventInfo
        });
    }
    else {
        pendingEvents.push(eventInfo);
    }
}
exports.tickEvent = tickEvent;
